package co.carmentang.bonvoyage;


import java.util.ArrayList;
import java.util.HashMap;

import android.util.Log;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

//this is the data handler file

public class DBController extends SQLiteOpenHelper {

    private static final String LOGCAT = null;

    // Table Name
    private static final String TABLE_GALLERY = "gallery";

    public DBController(Context applicationcontext) {
        super(applicationcontext, "albumtwo.db", null, 1);
        Log.d(LOGCAT,"Created");
    }

    // this creates the table for the database

    @Override
    public void onCreate(SQLiteDatabase database) {
        String query;
        query = "CREATE TABLE album (albumID INTEGER PRIMARY KEY, albumName TEXT, entryTitle TEXT, entry TEXT)";
        database.execSQL(query);
        Log.d(LOGCAT,"database Created");
    }
    @Override
    public void onUpgrade(SQLiteDatabase database, int version_old, int current_version) {
        String query;
        query = "DROP TABLE IF EXISTS album";
        database.execSQL(query);
        onCreate(database);
    }

    // the methods of the database ... to be edited

    //create method: insert

    public void insertAlbumName (HashMap<String, String> queryValues) {
        SQLiteDatabase database = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("albumName", queryValues.get("albumName"));
        database.insert("album", null, values);
        database.close();
    }

    // update method

    public int updateAlbumName (HashMap<String, String> queryValues) {
        SQLiteDatabase database = this.getWritableDatabase();
        ContentValues values = new ContentValues();
        values.put("albumName", queryValues.get("albumName"));
        return database.update("album", values, "albumId" + " = ?", new String[] { queryValues.get("albumId") });
        //String updateQuery = "Update  words set txtWord='"+word+"' where txtWord='"+ oldWord +"'";
        //Log.d(LOGCAT,updateQuery);
        //database.rawQuery(updateQuery, null);
        //return database.update("words", values, "txtWord  = ?", new String[] { word });
    }

    // delete method
    public void deleteAlbumName (String id) {
        Log.d(LOGCAT,"delete");
        SQLiteDatabase database = this.getWritableDatabase();
        String deleteQuery = "DELETE FROM  album where albumId='"+ id +"'";
        Log.d("query",deleteQuery);
        database.execSQL(deleteQuery);
    }

    // read method????


    public ArrayList<HashMap<String, String>> getAllAnimals() {
        ArrayList<HashMap<String, String>> wordList;
        wordList = new ArrayList<HashMap<String, String>>();
        String selectQuery = "SELECT  * FROM album";
        SQLiteDatabase database = this.getWritableDatabase();
        Cursor cursor = database.rawQuery(selectQuery, null);
        if (cursor.moveToFirst()) {
            do {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("albumId", cursor.getString(0));
                map.put("albumName", cursor.getString(1));
                wordList.add(map);
            } while (cursor.moveToNext());
        }

        // return contact list
        return wordList;
    }

    public HashMap<String, String> getAnimalInfo(String id) {
        HashMap<String, String> wordList = new HashMap<String, String>();
        SQLiteDatabase database = this.getReadableDatabase();
        String selectQuery = "SELECT * FROM album where albumId='"+id+"'";
        Cursor cursor = database.rawQuery(selectQuery, null);
        if (cursor.moveToFirst()) {
            do {
                //HashMap<String, String> map = new HashMap<String, String>();
                wordList.put("albumName", cursor.getString(1));
                //wordList.add(map);
            } while (cursor.moveToNext());
        }
        return wordList;
    }

    // Select All Data
    public String[][] SelectAllData() {
        // TODO Auto-generated method stub

        try {
            String arrData[][] = null;
            SQLiteDatabase db;
            db = this.getReadableDatabase(); // Read Data

            String strSQL = "SELECT  * FROM " + TABLE_GALLERY;
            Cursor cursor = db.rawQuery(strSQL, null);

            if(cursor != null)
            {
                if (cursor.moveToFirst()) {
                    arrData = new String[cursor.getCount()][cursor.getColumnCount()];
                    /***
                     *  [x][0] = GalleryID
                     *  [x][1] = Name
                     *  [x][2] = Path
                     */
                    int i= 0;
                    do {
                        arrData[i][0] = cursor.getString(0);
                        arrData[i][1] = cursor.getString(1);
                        arrData[i][2] = cursor.getString(2);
                        i++;
                    } while (cursor.moveToNext());

                }
            }
            cursor.close();

            return arrData;

        } catch (Exception e) {
            return null;
        }

    }


}
